'use strict';

function NoteCtrl($scope, $rootScope, MbNote, NotesStorage, UserGroups, NotesConfiguration){

    $scope.groups = UserGroups.load();
    $scope.groupNote = false;
    $scope.add = true;

    $scope.isEditable = function(){
        return $scope.orgNote.isEditable();
    };

    $scope.note = new MbNote({
        id: null,
        note: '',
        user_id: NotesConfiguration.userId,
        group_id: null,
        task_id: null,
        position_x: 0,
        position_y: 0,
        book_id: 1,
        page_id: 0
    });

    $scope.orgNote = new MbNote();

    $scope.$on('Notes:addNote', function(event, object){
        console.log(object);
        $scope.note.position_x = object.x;
        $scope.note.position_y = object.y;
        $scope.note.page_id = object.page['-id'];
        $scope.note.id = null;
        $scope.note.note = '';
        $scope.note.setCurrentTimestamp();

        $scope.orgNote = angular.copy($scope.note);
        $scope.add = true;
        angular.element('#modal-note').modal('show');
    });

    $scope.$on('Notes:editNote', function(event, note){
        $scope.orgNote = note;
        $scope.groupNote = ($scope.orgNote.group_id > 0) ? true : false;
        $scope.note = angular.copy(note);
        $scope.add = false;
        angular.element('#modal-note').modal('show');
        $scope.$apply();
    });




    $scope.closeModal = function(){
        angular.element('#modal-note').modal('hide');
    }

    $scope.saveNote = function(){
        if($scope.orgNote.isEditable())
        {
            $scope.orgNote.note = $scope.note.note;
            $scope.orgNote.group_id = ($scope.groupNote) ? $scope.groups[0].id : 0;
            if($scope.orgNote.id > 0)
            {
                $scope.orgNote.setCurrentTimestamp();
            }
            NotesStorage.saveNote($scope.orgNote);
            $scope.closeModal();
        }
    }

    $scope.deleteNote = function(){
        NotesStorage.deleteNote($scope.orgNote);
        $scope.closeModal();
    }


}

NoteCtrl.$inject = ['$scope', '$rootScope', 'MbNote', 'NotesStorage', 'UserGroups', 'NotesConfiguration'];